/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betternether.entity;

import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.FlyingMoveControl;
import net.minecraft.world.entity.ai.control.LookControl;
import net.minecraft.world.entity.animal.FlyingAnimal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.betterx.betternether.MHelper;
import org.betterx.betternether.registry.SoundsRegistry;

public class EntitySkull
extends Monster
implements FlyingAnimal {
    private static double particleX;
    private static double particleY;
    private static double particleZ;
    private int attackTick;
    private int dirTickTick;
    private int collideTick;

    public EntitySkull(EntityType<? extends EntitySkull> type, Level world) {
        super(type, world);
        this.f_21342_ = new FlyingMoveControl((Mob)this, 20, true);
        this.f_21365_ = new SkullLookControl((Mob)this);
        this.m_21441_(BlockPathTypes.LAVA, -1.0f);
        this.m_21441_(BlockPathTypes.WATER, -1.0f);
        this.m_21441_(BlockPathTypes.DANGER_FIRE, 0.0f);
        this.f_21364_ = 1;
    }

    public static AttributeSupplier.Builder createMobAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 4.0).m_22268_(Attributes.f_22277_, 20.0).m_22268_(Attributes.f_22279_, 0.5).m_22268_(Attributes.f_22280_, 0.5).m_22268_(Attributes.f_22281_, 1.0);
    }

    protected float m_274460_() {
        return this.m_6688_() instanceof Player ? this.m_6113_() * 0.1f : 0.5f;
    }

    public boolean m_29443_() {
        return !this.m_20096_();
    }

    public void m_6123_(Player player) {
        ++this.collideTick;
        if (this.collideTick > 25) {
            boolean shield;
            this.collideTick = 0;
            boolean bl = shield = player.m_21211_().m_41720_() instanceof ShieldItem && player.m_6117_();
            if (shield) {
                player.m_5496_(SoundEvents.f_12346_, MHelper.randRange(0.8f, 1.2f, this.f_19796_), MHelper.randRange(0.8f, 1.2f, this.f_19796_));
                this.m_20256_(new Vec3(0.0, 0.0, 0.0).m_82546_(this.m_20184_()));
            }
            if (player instanceof ServerPlayer) {
                if (shield) {
                    player.m_21211_().m_220157_(1, this.f_19796_, (ServerPlayer)player);
                    if (player.m_21211_().m_41773_() > player.m_21211_().m_41776_()) {
                        player.m_21190_(player.m_7655_());
                        if (player.m_7655_().equals((Object)InteractionHand.MAIN_HAND)) {
                            player.m_150109_().f_35974_.clear();
                        } else if (player.m_7655_().equals((Object)InteractionHand.OFF_HAND)) {
                            player.m_150109_().f_35976_.clear();
                        }
                        player.m_5810_();
                    }
                    return;
                }
                player.m_6469_(player.m_269291_().m_269264_(), 1.0f);
                if (this.f_19796_.m_188503_(16) == 0) {
                    player.m_20254_(3);
                }
            }
        }
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.f_19796_.m_188503_(3) == 0) {
            this.updateParticlePos();
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123762_, particleX, particleY, particleZ, 0.0, 0.0, 0.0);
        }
        if (this.f_19796_.m_188503_(3) == 0) {
            this.updateParticlePos();
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123800_, particleX, particleY, particleZ, 0.0, 0.0, 0.0);
        }
        if (this.f_19796_.m_188503_(3) == 0) {
            this.updateParticlePos();
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123744_, particleX, particleY, particleZ, 0.0, 0.0, 0.0);
        }
        if (this.attackTick > 40 && this.m_6084_()) {
            Player target = this.m_9236_().m_45924_(this.m_20185_(), this.m_20186_(), this.m_20189_(), 20.0, true);
            if (target != null && this.m_142582_((Entity)target)) {
                this.attackTick = 0;
                Vec3 velocity = target.m_20182_().m_82520_(0.0, (double)(target.m_20206_() * 0.5f), 0.0).m_82546_(this.m_20182_()).m_82541_().m_82490_((double)this.m_274460_());
                this.m_20256_(velocity);
                this.m_21391_((Entity)target, 360.0f, 360.0f);
                this.m_5496_((SoundEvent)SoundsRegistry.MOB_SKULL_FLIGHT.m_203334_(), MHelper.randRange(0.15f, 0.3f, this.f_19796_), MHelper.randRange(0.9f, 1.5f, this.f_19796_));
            } else if (this.dirTickTick < 0) {
                this.dirTickTick = MHelper.randRange(20, 60, this.f_19796_);
                this.moveRandomDir();
            }
        } else if (this.dirTickTick < 0) {
            this.dirTickTick = MHelper.randRange(20, 60, this.f_19796_);
            this.moveRandomDir();
        }
        ++this.attackTick;
        --this.dirTickTick;
    }

    protected SoundEvent m_7515_() {
        return SoundEvents.f_12423_;
    }

    protected SoundEvent m_7975_(DamageSource source) {
        return SoundEvents.f_12381_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_12424_;
    }

    private void moveRandomDir() {
        double dz;
        double dy;
        double dx = this.f_19796_.m_188500_() - 0.5;
        double l = dx * dx + (dy = this.f_19796_.m_188500_() - 0.5) * dy + (dz = this.f_19796_.m_188500_() - 0.5) * dz;
        l = l == 0.0 ? 1.0 : (double)((float)Math.sqrt(l));
        this.m_20334_(dx /= (l /= (double)this.m_274460_()), dy /= l, dz /= l);
        this.lookAt(this.m_20182_().m_82549_(this.m_20184_()));
        this.m_5496_((SoundEvent)SoundsRegistry.MOB_SKULL_FLIGHT.m_203334_(), MHelper.randRange(0.15f, 0.3f, this.f_19796_), MHelper.randRange(0.75f, 1.25f, this.f_19796_));
    }

    private void lookAt(Vec3 target) {
        double d = target.m_7096_() - this.m_20185_();
        double e = target.m_7094_() - this.m_20189_();
        double g = target.m_7098_() - this.m_20186_();
        double h = Math.sqrt(d * d + e * e);
        float i = (float)(Mth.m_14136_((double)e, (double)d) * 57.2957763671875) - 90.0f;
        float j = (float)(-(Mth.m_14136_((double)g, (double)h) * 57.2957763671875));
        this.m_146926_(j);
        this.m_146922_(i);
    }

    private void updateParticlePos() {
        particleX = this.f_19796_.m_188500_() - 0.5;
        double l = particleX * particleX + (particleY = this.f_19796_.m_188500_() - 0.5) * particleY + (particleZ = this.f_19796_.m_188500_() - 0.5) * particleZ;
        l = l == 0.0 ? 1.0 : (double)((float)Math.sqrt(l));
        particleX = particleX * 0.5 / l + this.m_20185_();
        particleY = particleY * 0.5 / l + this.m_20186_();
        particleZ = particleZ * 0.5 / l + this.m_20189_();
    }

    @Environment(value=EnvType.CLIENT)
    public float m_20236_(Pose pose) {
        return this.m_6972_((Pose)pose).f_20378_ * 0.5f;
    }

    protected boolean m_142039_() {
        return true;
    }

    public MobType m_6336_() {
        return MobType.f_21641_;
    }

    public boolean m_142535_(float fallDistance, float damageMultiplier, DamageSource source) {
        return false;
    }

    protected void m_7840_(double heightDifference, boolean onGround, BlockState landedState, BlockPos landedPosition) {
    }

    public boolean m_20068_() {
        return true;
    }

    public boolean m_6094_() {
        return false;
    }

    public static boolean canSpawn(EntityType<? extends EntitySkull> type, LevelAccessor world, MobSpawnType spawnReason, BlockPos pos, RandomSource random) {
        try {
            if (world.m_46791_() == Difficulty.PEACEFUL || world.m_46803_(pos) > 7) {
                return false;
            }
            if (pos.m_123342_() >= world.m_6042_().f_156647_()) {
                return false;
            }
            AABB box = new AABB(pos).m_82377_(256.0, 256.0, 256.0);
            List list = world.m_6443_(EntitySkull.class, box, entity -> true);
            return list.size() < 4;
        }
        catch (Exception e) {
            return true;
        }
    }

    class SkullLookControl
    extends LookControl {
        SkullLookControl(Mob entity) {
            super(entity);
        }

        protected boolean m_8106_() {
            return false;
        }
    }
}

